/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.python.google.common.base.Preconditions;
import org.python.google.common.collect.Lists;
import org.python.google.common.collect.Ordering;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true)
final class ComparatorOrdering<T>
extends Ordering<T>
implements Serializable {
    final Comparator<T> comparator;
    private static final long serialVersionUID = 0L;

    ComparatorOrdering(Comparator<T> comparator) {
        this.comparator = Preconditions.checkNotNull(comparator);
    }

    @Override
    public int compare(T t, T t2) {
        return this.comparator.compare(t, t2);
    }

    @Override
    public int binarySearch(List<? extends T> list, T t) {
        return Collections.binarySearch(list, t, this.comparator);
    }

    @Override
    public <E extends T> List<E> sortedCopy(Iterable<E> iterable) {
        ArrayList<E> arrayList = Lists.newArrayList(iterable);
        Collections.sort(arrayList, this.comparator);
        return arrayList;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ComparatorOrdering) {
            ComparatorOrdering comparatorOrdering = (ComparatorOrdering)object;
            return ((Object)this.comparator).equals(comparatorOrdering.comparator);
        }
        return false;
    }

    public int hashCode() {
        return this.comparator.hashCode();
    }

    public String toString() {
        return this.comparator.toString();
    }
}

